/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.ar;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.util.GenericNonValidatingParser;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.TimeProblemFilter;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.ar.DistributedSystemAnalysisRoutine;
import com.ibm.hwmca.p.pa.event.RioDomainAnalysisEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RioDomainAnalysisRoutine
extends DistributedSystemAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPARDART";
    private static final String TRACE_MASKF = "PPARDARF";
    private static final String TRACE_MASKD = "PPARDARD";

    public RioDomainAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKT, "--> RioDomainAnalysisRoutine.analyze()");
        RioDomainAnalysisEvent ourEvent = (RioDomainAnalysisEvent)event;
        String path = null;
        boolean powerFailure = false;
        try {
            path = BaseFileControl.getFilePath("paconfig");
        }
        catch (Exception e) {
            // empty catch block
        }
        String xmlFileToUse = path + "rioRefCode.xml";
        NodeList refcodePriorities = null;
        try {
            refcodePriorities = GenericNonValidatingParser.parseXMLFileNameForTag(xmlFileToUse, "rioErrors");
            if (refcodePriorities != null) {
                Trace.trace(TRACE_MASKD, "have an RB");
            } else {
                Trace.trace(TRACE_MASKD, "do not have an RB");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "ParsingRioAnalysisEvent"), Short.parseShort("0"), Short.parseShort("1"), 0);
            microCodeEvent.log();
            return;
        }
        PASystem system = ourEvent.getSystem();
        String poolId = ourEvent.getIncidentPoolId();
        IncidentPool thePool = RioDomainAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        if (thePool == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): no pool to analyze");
            return;
        }
        ArrayList<CommonServiceIncident> remList = new ArrayList<CommonServiceIncident>();
        CommonServiceIncident topIncident = null;
        Object anIncident = null;
        List sortedList = this.sortIncidentPool(thePool);
        thePool.clear();
        HashMap systemNtimes = this.correlateIncidentPool(sortedList);
        Set sysKeys = systemNtimes.keySet();
        if (sysKeys == null) {
            Trace.trace(TRACE_MASKD, "how can this be no system keys? ");
            Trace.trace(TRACE_MASKD, "return <-- analyze ");
            return;
        }
        Iterator skI = sysKeys.iterator();
        while (skI.hasNext()) {
            String key = (String)skI.next();
            Trace.trace(TRACE_MASKD, "operating with system " + key);
            HashMap timeNincidents = (HashMap)systemNtimes.get(key);
            if (timeNincidents == null) {
                Trace.trace(TRACE_MASKD, "how can this be no times and incidents?? for " + key);
                continue;
            }
            Set tniKeys = timeNincidents.keySet();
            if (tniKeys == null) {
                Trace.trace(TRACE_MASKD, "how can this be no key in our time n incidents?? for " + key);
                continue;
            }
            Iterator tniI = tniKeys.iterator();
            while (tniI.hasNext()) {
                String timeKey = (String)tniI.next();
                ArrayList timedIncidents = (ArrayList)timeNincidents.get(timeKey);
                Trace.trace(TRACE_MASKD, key + " timeFrame has of " + timeKey + " has " + timedIncidents.size() + " incidents ");
                Iterator tiI = timedIncidents.iterator();
                while (tiI.hasNext()) {
                    CommonServiceIncident csi = (CommonServiceIncident)tiI.next();
                    CommonProblem thisProblem = csi.getProblem();
                    Trace.trace(TRACE_MASKD, key + " incident RefCode " + thisProblem.getRefcode() + " has  a time of " + new Date(thisProblem.getLastReportedTimestamp()));
                    float priority = RioDomainAnalysisRoutine.getRefcodePriority(refcodePriorities, thisProblem.getRefcode());
                    if (priority > 0.0f) {
                        csi.setPriority(priority);
                    } else {
                        priority = csi.getPriority();
                    }
                    if (topIncident == null) {
                        topIncident = csi;
                        topIncident.setPriority(priority);
                        continue;
                    }
                    if (priority > topIncident.getPriority()) {
                        remList.add(topIncident);
                        topIncident = csi;
                        topIncident.setPriority(priority);
                        continue;
                    }
                    remList.add(csi);
                }
                Trace.trace(TRACE_MASKD, "auxiallary list remList.size()= " + remList.size());
                Iterator rlI = remList.iterator();
                while (rlI.hasNext()) {
                    CommonServiceIncident associateIncident = (CommonServiceIncident)rlI.next();
                    topIncident.getProblem().addSecondaryDataEvent(associateIncident.getProblem().getPrimaryDataEvent());
                }
                Trace.trace(TRACE_MASKD, "all problems except top problem are now removed  = " + thePool.size());
                PIFru highFru = this.getHighFru(topIncident);
                if (highFru != null) {
                    powerFailure = this.isPowerFailure(highFru);
                }
                if (powerFailure) {
                    Trace.trace(TRACE_MASKT, "this is attributed to a power failure don't report it don't add back to the pool");
                    Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, "RIO event discarded due to powerFailure");
                    String dataString = "refcode: " + topIncident.getProblem().getRefcode();
                    theLog.add((byte)3, dataString);
                    theLog.log();
                    continue;
                }
                Trace.trace(TRACE_MASKD, key + "not attributable to power failiure add the back to pool incident RefCode " + topIncident.getProblem().getRefcode() + " has  a time of " + new Date(topIncident.getProblem().getLastReportedTimestamp()));
                thePool.add(topIncident);
            }
        }
        this.postServiceAREvent(new CommonServiceAREvent(this), system, poolId);
        Trace.trace(TRACE_MASKT, "<-- " + this.getClass().getName() + " Analyze()");
    }

    private PIFru getHighFru(CommonServiceIncident topIncident) {
        PIFru highFru = null;
        boolean highFruPri = false;
        XMLEncodeableArrayList thisFruList = ((DistributedDataEvent)topIncident.getProblem().getPrimaryDataEvent()).getFruList();
        for (int y = 0; y < thisFruList.size(); ++y) {
            PIFru thisFru = (PIFru)thisFruList.get(y);
            if (highFru == null) {
                highFru = thisFru;
                continue;
            }
            if (thisFru.getNumericPriority() <= highFru.getNumericPriority()) continue;
            highFru = thisFru;
        }
        return highFru;
    }

    private boolean isPowerFailure(PIFru highFru) {
        boolean powerFailure = false;
        String highFruPowerMTMS = null;
        if (highFru.getPowerControllingSystem() != null) {
            highFruPowerMTMS = highFru.getPowerControllingSystem().getMTMS();
        }
        if (highFru.getPowerControllingSystem() == null && highFru.getEnclosureSystem() != null) {
            highFruPowerMTMS = highFru.getEnclosureSystem().getMTMS();
        }
        if (highFruPowerMTMS != null) {
            Trace.trace(TRACE_MASKD, "highFruPowerMTMS = " + highFruPowerMTMS);
            Set analyzingPools = RioDomainAnalysisRoutine.getAnalyzingIncidentPoolIdSet();
            Iterator apIds = analyzingPools.iterator();
            while (apIds.hasNext()) {
                String analyzingPoolId = (String)apIds.next();
                if (analyzingPoolId.indexOf(highFruPowerMTMS) != -1) continue;
                IncidentPool fruPool = RioDomainAnalysisRoutine.getAnalyzingIncidentPool(analyzingPoolId);
                Trace.trace(TRACE_MASKD, "Highest Priority fru analyzing pool size=" + fruPool.size());
                Iterator fpi = fruPool.iterator();
                int highOrder = -128;
                while (fpi.hasNext()) {
                    CommonServiceIncident fruPoolIncident = (CommonServiceIncident)fpi.next();
                    byte[] refcode = HexString.toHexBytes(((DistributedDataEvent)fruPoolIncident.getProblem().getPrimaryDataEvent()).getRefcode());
                    if ((refcode[0] & highOrder) != highOrder) continue;
                    powerFailure = true;
                    Trace.trace(TRACE_MASKT, "Highest Priority fru had a power failure");
                }
            }
        }
        if (!powerFailure) {
            Trace.trace(TRACE_MASKD, "HighFru did not exist in the analyzing pools look at recent problems");
            powerFailure = this.checkRecentProblems(highFruPowerMTMS);
        }
        return powerFailure;
    }

    public static float getRefcodePriority(NodeList refcodePriorities, String refcode) {
        float priority = 0.0f;
        ArrayList problems = new ArrayList();
        problems = XMLHelper.getNodes("problem", refcodePriorities);
        Trace.trace(TRACE_MASKD, " problems nodes found = " + problems.size());
        if (problems == null) {
            return priority;
        }
        for (int i = 0; i < problems.size(); ++i) {
            Node probNode = (Node)problems.get(i);
            try {
                String value = XMLHelper.getAttributeValue(probNode, "refcode");
                Trace.trace(TRACE_MASKD, "refcode value " + value);
                if (!Pattern.matches(refcode, value)) continue;
                String xmlPriority = XMLHelper.getAttributeValue(probNode, "priority");
                Trace.trace(TRACE_MASKD, "priority=" + xmlPriority);
                return Float.parseFloat(xmlPriority);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "Error using regular expressions " + e);
            }
        }
        return priority;
    }

    private boolean checkRecentProblems(String highFruPowerMTMS) {
        ArrayList timeFilteredProblems = new ArrayList();
        List knownProblems = null;
        try {
            knownProblems = ProblemManager.getProblemManager().getAllProblems();
        }
        catch (PersistenceNotInitializedException e1) {
            e1.printStackTrace();
        }
        catch (ProblemPersistenceException e1) {
            e1.printStackTrace();
        }
        TimeProblemFilter timeFilter = new TimeProblemFilter(300000L);
        timeFilteredProblems.clear();
        if (knownProblems != null) {
            timeFilter.filter(timeFilteredProblems, knownProblems);
        }
        for (int i = 0; i < timeFilteredProblems.size(); ++i) {
            CommonProblem cpTFP = (CommonProblem)timeFilteredProblems.get(i);
            if (!cpTFP.getReportingRemoteMachineSystem().getMTMS().equals(highFruPowerMTMS)) continue;
            Trace.trace(TRACE_MASKD, "recent problem indicate a power failure" + cpTFP.getProblemNumber());
            return true;
        }
        return false;
    }
}

